/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class TiddlySaver
extends Applet {
    private static final boolean restrictToSameDirectory = false;
    private static final boolean allowSystemProperties = true;
    private String lastErrorMsg;
    private String lastErrorStackTrace;
    private StringBuilder debugMsg = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadFile(String filename, String charset) {
        StringBuilder sb = new StringBuilder();
        try (FileInputStream in = this.privInputStream(filename);
             InputStreamReader reader = TiddlySaver.isNullOrEmpty(charset) ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, charset);){
            int len;
            char[] buff = new char[4096];
            while ((len = reader.read(buff)) >= 0) {
                sb.append(buff, 0, len);
            }
        }
        catch (Exception e) {
            this.logAndRethrow("loadFile", e);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveFile(String filename, String charset, String data) {
        try (FileOutputStream out = this.privOutputStream(filename);
             OutputStreamWriter writer = TiddlySaver.isNullOrEmpty(charset) ? new OutputStreamWriter(out) : new OutputStreamWriter((OutputStream)out, charset);){
            writer.write(data);
        }
        catch (Exception e) {
            this.logAndRethrow("saveFile", e);
        }
        return 1;
    }

    public boolean exists(String filename) {
        boolean b = false;
        try {
            b = this.privExists(filename);
        }
        catch (Exception e) {
            this.logAndRethrow("exists", e);
        }
        return b;
    }

    public long modificationTime(String filename) {
        long millis = 0L;
        try {
            millis = this.privModificationTime(filename);
            if (millis == 0L) {
                throw new IOException("Unable to get file modification time: " + filename);
            }
        }
        catch (Exception e) {
            this.logAndRethrow("modificationTime", e);
        }
        return millis;
    }

    public String[] listFiles(String dirname) {
        String[] filenames = null;
        try {
            filenames = this.privList(dirname);
            if (filenames == null) {
                throw new IOException("Not a directory:" + dirname);
            }
        }
        catch (Exception e) {
            this.logAndRethrow("listFiles", e);
        }
        return filenames;
    }

    public String getJavaVersion() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.version");
            }
        });
    }

    public String getSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, false);
                System.getProperties().list(pw);
                pw.flush();
                return sw.toString();
            }
        });
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    private FileInputStream privInputStream(final String filename) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                return new FileInputStream(TiddlySaver.this.resolveFilename(filename));
            }
        });
    }

    private FileOutputStream privOutputStream(final String filename) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws Exception {
                File f = TiddlySaver.this.resolveFilename(filename);
                File dir = f.getParentFile();
                if (dir != null && !dir.exists() && !dir.mkdirs()) {
                    throw new IOException("Unable to create directory for: " + filename);
                }
                return new FileOutputStream(f);
            }
        });
    }

    private boolean privExists(final String filename) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File f = TiddlySaver.this.resolveFilename(filename);
                return f.exists();
            }
        });
    }

    private long privModificationTime(final String filename) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                File f = TiddlySaver.this.resolveFilename(filename);
                return f.lastModified();
            }
        });
    }

    private String[] privList(final String dirname) {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                File f = TiddlySaver.this.resolveFilename(dirname);
                return f.list();
            }
        });
    }

    public String getLastErrorMsg() {
        return this.lastErrorMsg;
    }

    public String getLastErrorStackTrace() {
        return this.lastErrorStackTrace;
    }

    private void logAndRethrow(String msg, Exception e) {
        Throwable rootCause = e;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        this.lastErrorMsg = rootCause.toString();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        rootCause.printStackTrace(pw);
        pw.flush();
        this.lastErrorStackTrace = sw.toString();
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public final File resolveFilename(String filename) {
        this.debugMsg.setLength(0);
        this.debug("Filename:", filename);
        filename = TiddlySaver.utf8DecodeHack(filename);
        this.debug("UTF8DecodeHack:", filename);
        try {
            File f = new File(filename);
            return f;
        }
        catch (Exception e) {
            this.lastErrorMsg = e.toString();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private File privCanonicalFile(final File f) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

            @Override
            public File run() throws Exception {
                return f.getCanonicalFile();
            }
        });
    }

    private void debug(Object ... args) {
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            this.debugMsg.append(args[i].toString());
            if (i < size - 1) {
                this.debugMsg.append(" ");
                continue;
            }
            this.debugMsg.append("\n");
        }
    }

    public String getDebugMsg() {
        return this.debugMsg.toString();
    }

    private static String utf8DecodeHack(String s) {
        try {
            byte[] b = s.getBytes("ISO-8859-1");
            String s2 = new String(b, "UTF-8");
            if (s2.indexOf("\ufffd") != -1) {
                return s;
            }
            return s2;
        }
        catch (UnsupportedEncodingException use) {
            System.out.println("Exception " + use);
            return s;
        }
    }
}

